/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V2.0.1
* Date               : 06/13/2008
* Description        : Main program body
********************************************************************************
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
// Interface LCD Nikia-6610 By GPIO Function
// STM32F103RBT6    <--->  LCD Nokia-6610 
// PB.8(GPIO:OUT)   ---->  BL = PB[8]
// PB.9(GPIO:OUT)   ---->  CS = PB[9]
// PB.10(GPIO:OUT)  ---->  SCLK = PB[10]
// PB.11(GPIO:OUT)  ---->  SDATA = PB[11]
// PB.12(GPIO:OUT)  ---->  RESET = PB[12]

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_lib.h"
#include "platform_config.h"

/* Define For NOKIA-6610 */
#include "font.h"			// Font Table Code
#include "bmp.h"			// Bitmap Graphic File
//#include "bug.h"			// Bitmap Graphic File

/* Define For Select NOKIA6610 Controller */
/* Philips(NXP):PCF8833 Controller Version */
//#include "pcf8833.h"			// LCD-NOKIA6610 Philips(NXP):PCF8833 Controller
//#include "pcf8833.c"

/* Epson:S1D15G00 Controller Version */
#include "s1d15g00.h"			// LCD-NOKIA6610 Epson:S1D15G00 Controller
#include "s1d15g00.c"
/* End Define NOKIA-6610 */

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
GPIO_InitTypeDef GPIO_InitStructure;
ErrorStatus HSEStartUpStatus;

/* Private function prototypes -----------------------------------------------*/
void RCC_Configuration(void);
void NVIC_Configuration(void);
void Delay(vu32 nCount);

/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main program.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main(void)
{
  unsigned long j;
  int TempColor[11] = { WHITE, BLACK, RED, GREEN, BLUE, CYAN,
                        MAGENTA, YELLOW, BROWN, ORANGE, PINK };

  char *TempChar[11] = { "White  ", "Black  ", "Red    ", "Green  ", "Blue   ", "Cyan   ",
                         "Magenta", "Yellow ", "Brown  ", "Orange ", "Pink   " };

#ifdef DEBUG
  debug();
#endif

  /* System Clocks Configuration **********************************************/
  RCC_Configuration();   

  /* NVIC Configuration *******************************************************/
  NVIC_Configuration();

  /* Configure IO connected to LCD-NOKIA6610 */
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIO_BL, ENABLE);
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Pin = LCD_BL_PIN;
  GPIO_Init(LCD_BL_PORT, &GPIO_InitStructure);

  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIO_CS, ENABLE);
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Pin = LCD_CS_PIN;
  GPIO_Init(LCD_CS_PORT, &GPIO_InitStructure);

  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIO_SCLK, ENABLE);
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Pin = LCD_SCLK_PIN;
  GPIO_Init(LCD_SCLK_PORT, &GPIO_InitStructure);

  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIO_SDATA, ENABLE);
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Pin = LCD_SDATA_PIN;
  GPIO_Init(LCD_SDATA_PORT, &GPIO_InitStructure);

  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIO_RESET, ENABLE);
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Pin = LCD_RESET_PIN;
  GPIO_Init(LCD_RESET_PORT, &GPIO_InitStructure);

  /* Config GPIO Control LCD */    
  LCD_SCLK_LO();   												// Standby SCLK
  LCD_CS_HI();													// Disable CS
  LCD_SDATA_HI();												// Standby SDATA
  LCD_BL_HI();													// Black Light ON = 100%

  // Init LCD
  InitLcd(); 													// Initial LCD

  // Loop Test Display //
  while(1)
  {  
    // Test[1]  
    LCDClearScreen();											// Clear Screen	
    for (j = 0; j < 11; j++) 
    {    
      LCDSetRect(120, 10, 25, 120, FILL, TempColor[j]);  		// Draw Fill Box with Color
      LCDPutStr(TempChar[j], 5, 40, LARGE, YELLOW, BLACK);		// Label Name of Color    
      Delay(20000000); 											// Delay Page Display
    }

    // Test[2] 
    LCDClearScreen();											// Clear Screen		    
    LCDPutStr("Hello World", 60, 5, SMALL, WHITE, BLACK);  		// Draw String
    LCDPutStr("Hello World", 40, 5, MEDIUM, ORANGE, BLACK);
    LCDPutStr("Hello World", 20, 5, LARGE, PINK, BLACK);     
    LCDSetLine(120, 10, 120, 50, YELLOW); 						// Draw Line Create Rectangle
    LCDSetLine(120, 50, 80, 50, YELLOW);
    LCDSetLine(80, 50, 80, 10, YELLOW);
    LCDSetLine(80, 10, 120, 10, YELLOW);    
    LCDSetLine(120, 85, 80, 105, YELLOW);						// Draw Line Create X
    LCDSetLine(80, 85, 120, 105, YELLOW);    
    LCDSetCircle(65, 100, 10, RED);								// Draw Circle    
    LCDPutChar('E', 60, 98, SMALL, WHITE, BLACK);	 			// Draw Characters
    Delay(50000000); 											// Delay Page Display

    // Test[3]
    LCDClearScreen();	 										// Clear Screen
    LCDWrite130x130bmp();		   								// Display Graphic Bitmap 130x130
    LCDPutStr("This is Picture ", 115, 2, LARGE, BLACK, CYAN);
	Delay(50000000); 											// Delay Page Display
  }
}

/*******************************************************************************
* Function Name  : RCC_Configuration
* Description    : Configures the different system clocks.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void RCC_Configuration(void)
{   
  /* RCC system reset(for debug purpose) */
  RCC_DeInit();

  /* Enable HSE */
  RCC_HSEConfig(RCC_HSE_ON);

  /* Wait till HSE is ready */
  HSEStartUpStatus = RCC_WaitForHSEStartUp();

  if(HSEStartUpStatus == SUCCESS)
  {
    /* Enable Prefetch Buffer */
    FLASH_PrefetchBufferCmd(FLASH_PrefetchBuffer_Enable);

    /* Flash 2 wait state */
    FLASH_SetLatency(FLASH_Latency_2);
 	
    /* HCLK = SYSCLK */
    RCC_HCLKConfig(RCC_SYSCLK_Div1); 
  
    /* PCLK2 = HCLK */
    RCC_PCLK2Config(RCC_HCLK_Div1); 

    /* PCLK1 = HCLK/2 */
    RCC_PCLK1Config(RCC_HCLK_Div2);

    /* PLLCLK = 8MHz * 9 = 72 MHz */
    RCC_PLLConfig(RCC_PLLSource_HSE_Div1, RCC_PLLMul_9);

    /* Enable PLL */ 
    RCC_PLLCmd(ENABLE);

    /* Wait till PLL is ready */
    while(RCC_GetFlagStatus(RCC_FLAG_PLLRDY) == RESET)
    {
    }

    /* Select PLL as system clock source */
    RCC_SYSCLKConfig(RCC_SYSCLKSource_PLLCLK);

    /* Wait till PLL is used as system clock source */
    while(RCC_GetSYSCLKSource() != 0x08)
    {
    }
  }
}

/*******************************************************************************
* Function Name  : NVIC_Configuration
* Description    : Configures Vector Table base location.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void NVIC_Configuration(void)
{
#ifdef  VECT_TAB_RAM  
  /* Set the Vector Table base location at 0x20000000 */ 
  NVIC_SetVectorTable(NVIC_VectTab_RAM, 0x0); 
#else  /* VECT_TAB_FLASH  */
  /* Set the Vector Table base location at 0x08000000 */ 
  NVIC_SetVectorTable(NVIC_VectTab_FLASH, 0x0);   
#endif
}

/*******************************************************************************
* Function Name  : Delay
* Description    : Inserts a delay time.
* Input          : nCount: specifies the delay time length.
* Output         : None
* Return         : None
*******************************************************************************/
void Delay(vu32 nCount)
{
  for(; nCount != 0; nCount--);
}

#ifdef  DEBUG
/*******************************************************************************
* Function Name  : assert_failed
* Description    : Reports the name of the source file and the source line number
*                  where the assert_param error has occurred.
* Input          : - file: pointer to the source file name
*                  - line: assert_param error line source number
* Output         : None
* Return         : None
*******************************************************************************/
void assert_failed(u8* file, u32 line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif

/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
